
clear
* data for dec_2013 are input into row 73 to create dec2013_start.dta*
*use "dec2013_start.dta"

set more off

****put in actual values for Dec. 2013 in 73, emp nilf, u distribution*****
****make flows return to average by Dec. 2016******* 
gen usn = .109
gen uln = .259
gen nu = .0318
gen eu = .00776
gen en = .0119

***Simulate from December '13 forward back to average****

foreach i in usn uln nu eu en {
	gen ave_`i' = 0
forvalues j=73/`=_N' { 
	replace ave_`i' = lamda_`i'[73] + ((`i' - lamda_`i'[73])/36) * (`j'-73) in `j'

}
}

replace total_pop = u_short[73] + u_long[73] + employed[73] + notinthelaborforce[73]


***Actual vacancies in Dec '13 3914***
replace vacancies = 3914 if _n==73

**Vacancies grow at 32k per month***
replace vacancies = vacancies[_n-1] + 32 if _n>=74

forvalues i=74/`=_N' {
	forvalues j = 1/23 {
	replace u_0 = employed[_n-1]*ave_eu[_n-1]*var_65/100 + notinthelaborforce[_n-1]*ave_nu[_n-1]*var_40/100 in `i'
	replace notinthelaborforce = notinthelaborforce[_n-1] *(1 - ave_nu[_n-1] - (s[1] * m_0[1] * (vacancies[_n-1]/(u_short[_n-1] + gamma_1[1] * u_long[_n-1] + s[1]* notinthelaborforce[_n-1]))^(1-alpha[1]))) + employed[_n-1] * ave_en[_n-1] + u_long[_n-1] * ave_uln[_n-1] + u_short[_n-1] * ave_usn[_n-1] in `i' 
	local eu_num = 65 + `j'
	local nu_num = 40 + `j'
	local one_before = `j' - 1
	di `one_before'
	replace u_`j' = employed[_n-1]*ave_eu[_n-1]*var_`eu_num'/100 + notinthelaborforce[_n-1]*ave_nu[_n-1]*var_`nu_num'/100 + u_`one_before'[_n-1] * ( 1 - ave_usn[_n-1] - m_0[1] * (vacancies[_n-1]/(u_short[_n-1] + gamma_1[1] * u_long[_n-1] + s[1]* notinthelaborforce[_n-1]))^(1-alpha[1]))  in `i' if `j'<=5
	replace u_`j' = employed[_n-1]*ave_eu[_n-1]*var_`eu_num'/100 + notinthelaborforce[_n-1]*ave_nu[_n-1]*var_`nu_num'/100 + u_`one_before'[_n-1] * ( 1 - ave_uln[_n-1] - m_0[1] * gamma_1[1] * (vacancies[_n-1]/(u_short[_n-1] + gamma_1[1] * u_long[_n-1] + s[1]* notinthelaborforce[_n-1]))^(1-alpha[1])) in `i' if `j'>=6 
	replace u_`j' = employed[_n-1]*ave_eu[_n-1]*var_`eu_num'/100 + notinthelaborforce[_n-1]*ave_nu[_n-1]*var_`nu_num'/100 + (u_`one_before'[_n-1] + u_`j'[_n-1]) * ( 1 - ave_uln[_n-1] - m_0[1] * gamma_1[1] * (vacancies[_n-1]/(u_short[_n-1] + gamma_1[1] * u_long[_n-1] + s[1]* notinthelaborforce[_n-1]))^(1-alpha[1]))  in `i' if `j'==23 
	
	replace u_short = u_0 + u_1 + u_2 + u_3 + u_4 + u_5 in `i'
	replace u_long = u_6 + u_7 + u_8 + u_9 + u_10 + u_11 + u_12 + u_13 + u_14 + u_15 + u_16 + u_17 +  u_18 + u_19 + u_20 +  u_21 +    u_22 + u_23 in `i' 
	replace employed = total_pop[1] - u_short - u_long - notinthelaborforce in `i'
}
}

replace u_rate = (u_short + u_long) / (u_short + u_long + employed)

****Display 2013 forward****
drop if _n < 73

***Vacancies to labor force***

gen vacancy_rate = vacancies/(employed + u_short + u_long)

*keep long_share*

